packer {
  required_plugins {
    openstack = {
      version = "~> 1"
      source  = "github.com/hashicorp/openstack"
    }
    ansible = {
      version = "~> 1"
      source  = "github.com/hashicorp/ansible"
    }
  }
}

locals {
  local_image_name = "${var.image_name}${var.image_date_suffix ? formatdate("-YYYYMMDDHHmm", timestamp()) : ""}"
}

source "openstack" "image" {
  skip_create_image         = var.skip_create_image
  image_name                = local.local_image_name
  source_image              = var.source_image
  image_members             = var.image_membership
  image_auto_accept_members = var.auto_accept_members
  image_tags                = var.image_tags
  image_disk_format         = var.image_format
  volume_size               = var.volume_size
  flavor                    = var.flavor
  instance_name             = var.build_instance_name
  use_blockstorage_volume   = true
  floating_ip_network       = var.floating_ip_network
  networks                  = var.networks
  security_groups           = var.security_groups
  ssh_username              = var.ssh_username
}

build {
  sources = ["source.openstack.image"]

  provisioner "shell" {
    inline = [
      "sudo yum install -y epel-release",
      "sudo dnf config-manager --set-enabled crb",
      "sudo yum install -y libselinux-python3 python3 python3-pip tmux vim git bash-completion curl wget unzip",
      "sudo python3 -m pip install --upgrade pip",
      "sudo pip3 install s3cmd==2.3.0 ansible==4.10.0 python-openstackclient==5.8.0"
    ]
  }

  provisioner "ansible" {
    use_proxy        = false
    user             = var.ssh_username
    groups           = ["proxy"]
    ansible_env_vars = [
      "ANSIBLE_TIMEOUT=60",
      "ANSIBLE_HOST_KEY_CHECKING=False",
      "ANSIBLE_VERBOSITY=${var.ANSIBLE_VERBOSITY}",
      "ANSIBLE_DEBUG=${var.ANSIBLE_DEBUG}",
      "ANSIBLE_FORCE_COLOR=true"
    ]
    playbook_file    = "./CRI_XCBC/proxy.yaml"
  }
}
