variable "root_ssh_key" {
  type        = string
  default     = ""
  description = "The root key to use for ssh"
}

variable "image_name" {
  type        = string
  default     = "cluster-image"
  description = "Name of the image in openstack"
}

variable "image_format" {
  type        = string
  default     = "qcow2"
  description = "The format of the resulting image"
}

variable "image_date_suffix" {
  type        = bool
  default     = false
  description = "Append a date to the image name (in YYYYMMDDHHMMSS format)"
}

variable "image_tags" {
  type        = list(string)
  default     = []
  description = "List of tags to be associated to the resulting image"
}

variable "image_membership" {
  type        = list(string)
  default     = []
  description = "Projects/tenants to share the image in openstack with"
}

variable "auto_accept_members" {
  type        = bool
  default     = false
  description = "A boolean value for auto accepting image in the projects/tenants defined in image_membership."
}

variable "skip_create_image" {
  type        = bool
  default     = false
  description = "A boolean value for skipping image creation at the end of the build"
}

variable "source_image" {
  type        = string
  default     = ""
  description = "The name of the source image to use"
}

variable "flavor" {
  type        = string
  default     = ""
  description = "The name of the flavor to use"
}

variable "floating_ip_network" {
  type        = string
  default     = "uab-campus"
  description = "floating ip network to use with (temporary) ip assignmnet to a vm"
}

variable "networks" {
  type        = list(string)
  default     = []
  description = "List of network UUIDs to assign to the network"
}

variable "security_groups" {
  type        = list(string)
  default     = []
  description = "A list of security groups to add - you should make sure ssh access is open to the machine"
}

variable "build_instance_name" {
  type        = string
  default     = "ood"
  description = "A name of build instance used for image build"
}

variable "ssh_username" {
  type        = string
  default     = "centos"
  description = "The default username to use for SSH"
}

variable "volume_size" {
  type        = number
  default     = 20
  description = "The default volume size for building iamge"
}

variable "ANSIBLE_DEBUG" {
  type        = string
  default     = "false"
  description = "to turn on debugging"
}

variable "ANSIBLE_VERBOSITY" {
  type        = string
  default     = "0"
  description = "to increase verbosity - 0|1|2|3|4"
}

