# is created in external-network module and called in root module
terraform {
required_version = ">= 0.14.0"
  required_providers {
    openstack = {
      source  = "terraform-provider-openstack/openstack"
      version = "~> 1.42.0"
    }
  }
}

variable "external_subnet_id" {type = string}

variable "ohpc_instance_name" {}
variable "image_ohpc" {}
variable "flavor" {}

# is created in key-pair module and called in root module
variable "key_pair" {type = string}

variable "internal_network" {}
variable "internal_ip" {}
variable "external_network" {}

# is created in floating-ip module and called in root module
variable "floating_ip_ohpc" {type = string}

variable "ohpc_user" {}
variable "ssh_private_key" {}


# creates details for the OHPC instance
resource "openstack_compute_instance_v2" "ohpc" {
  depends_on      = [var.external_subnet_id]
  name            = var.ohpc_instance_name
  image_name      = var.image_ohpc
  flavor_name     = var.flavor
  key_pair        = var.key_pair
  security_groups = ["default"]
  user_data = <<-EOF
     #cloud-config
     write_files:
     - content: |
         10.1.1.10 ohpc ohpc.novalocal
       owner: centos:centos
       path: /etc/hosts
       permissions: 0644
     EOF

# defines the networks of the instance
  network {
    uuid = var.external_network
  }
  network {
    uuid = var.internal_network
    fixed_ip_v4 = var.internal_ip
  }
}

# associates floating ip with the OHPC instance
resource "openstack_compute_floatingip_associate_v2" "ohpc" {
  floating_ip = var.floating_ip_ohpc
  instance_id = openstack_compute_instance_v2.ohpc.id

# defines ssh connection
  connection {
    host = format(var.host_prefix,element(split(".", var.floating_ip_ohpc),3,),)
    user        = var.ohpc_user
    private_key = file(var.ssh_private_key)
  }
}

output "id" {
    value = openstack_compute_instance_v2.ohpc.id
}

output "ssh_host" {
    value = var.floating_ip_ohpc
}
